// Generated by CoffeeScript 1.7.1
(function() {
  var EventEmitter, binding, ipc,
    __slice = [].slice;

  EventEmitter = require('events').EventEmitter;

  binding = process.atomBinding('web_contents');

  ipc = require('ipc');

  module.exports.wrap = function(webContents) {
    if (!webContents.isAlive()) {
      return null;
    }
    webContents.__proto__ = EventEmitter.prototype;
    webContents.send = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return this._send('ATOM_INTERNAL_MESSAGE', __slice.call(args));
    };
    webContents.loaded = false;
    webContents.once('did-finish-load', function() {
      return this.loaded = true;
    });
    webContents.executeJavaScript = function(code) {
      if (this.loaded) {
        return this._executeJavaScript(code);
      } else {
        return webContents.once('did-finish-load', this._executeJavaScript.bind(this, code));
      }
    };
    webContents.getId = function() {
      return "" + (this.getProcessId()) + "-" + (this.getRoutingId());
    };
    webContents.equal = function(other) {
      return this.getId() === other.getId();
    };
    webContents.loadUrl = function(url, urlOptions) {
      if (urlOptions == null) {
        urlOptions = {};
      }
      return this._loadUrl(url, urlOptions);
    };
    webContents.reload = function(urlOptions) {
      if (urlOptions == null) {
        urlOptions = {};
      }
      return this._reload(urlOptions);
    };
    webContents.reloadIgnoringCache = function(urlOptions) {
      if (urlOptions == null) {
        urlOptions = {};
      }
      return this._reloadIgnoringCache(urlOptions);
    };
    webContents.on('-new-window', function() {
      var args, disposition, _i;
      args = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), disposition = arguments[_i++];
      disposition = (function() {
        switch (disposition) {
          case 2:
            return 'default';
          case 4:
            return 'foreground-tab';
          case 5:
            return 'background-tab';
          case 6:
          case 7:
            return 'new-window';
          default:
            return 'other';
        }
      })();
      return this.emit.apply(this, ['new-window'].concat(__slice.call(args), [disposition]));
    });
    webContents.on('render-view-deleted', function(event, processId, routingId) {
      return process.emit('ATOM_BROWSER_RELEASE_RENDER_VIEW', "" + processId + "-" + routingId);
    });
    webContents.on('ipc-message', function() {
      var args, channel, event;
      event = arguments[0], channel = arguments[1], args = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
      Object.defineProperty(event, 'sender', {
        value: webContents
      });
      return ipc.emit.apply(ipc, [channel, event].concat(__slice.call(args)));
    });
    webContents.on('ipc-message-sync', function() {
      var args, channel, event;
      event = arguments[0], channel = arguments[1], args = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
      Object.defineProperty(event, 'returnValue', {
        set: function(value) {
          return event.sendReply(JSON.stringify(value));
        }
      });
      Object.defineProperty(event, 'sender', {
        value: webContents
      });
      return ipc.emit.apply(ipc, [channel, event].concat(__slice.call(args)));
    });
    return webContents;
  };

  module.exports.create = function(options) {
    if (options == null) {
      options = {};
    }
    return this.wrap(binding.create(options));
  };

}).call(this);
